/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintReplyEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintReplyRepository;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintRepository;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintReplyFileService;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintReplyService;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintReplyDto;
import com.biz.crm.dms.business.interaction.sdk.enums.ComplaintState;
import com.biz.crm.dms.business.interaction.sdk.enums.ReplierType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="complaintReplyService")
public class ComplaintReplyServiceImpl
implements ComplaintReplyService {
    private static final Logger log = LoggerFactory.getLogger(ComplaintReplyServiceImpl.class);
    @Autowired(required=false)
    private ComplaintReplyRepository complaintReplyRepository;
    @Autowired(required=false)
    private ComplaintRepository complaintRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ComplaintReplyFileService complaintReplyFileService;

    @Override
    @Transactional
    public ComplaintReplyEntity create(ComplaintReplyDto dto) {
        String complaintState;
        this.createValidation(dto);
        ComplaintEntity complaintEntity = (ComplaintEntity)((Object)this.complaintRepository.getById((Serializable)((Object)dto.getComplaintId())));
        Validate.notNull((Object)((Object)complaintEntity), (String)"\u6295\u8bc9\u5efa\u8bae\u4e0d\u5b58\u5728,\u65e0\u6cd5\u56de\u590d!", (Object[])new Object[0]);
        if (ReplierType.FACTORY.getCode().equals(dto.getReplierType())) {
            complaintState = ComplaintState.WAIT_CUSTOMER_RETURN_VISIT.getCode();
        } else {
            Validate.isTrue((ComplaintState.WAIT_FACTORY_DEAL.getCode().equals(complaintEntity.getComplaintState()) || ComplaintState.WAIT_CUSTOMER_RETURN_VISIT.getCode().equals(complaintEntity.getComplaintState()) ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u6295\u8bc9\u5efa\u8bae\u72b6\u6001\u4e3a:%s,\u65e0\u6cd5\u56de\u590d!", ComplaintState.getDesc((String)complaintEntity.getComplaintState())), (Object[])new Object[0]);
            complaintState = ComplaintState.WAIT_FACTORY_DEAL.getCode();
        }
        ComplaintReplyEntity entity = (ComplaintReplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ComplaintReplyEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCreateTime(new Date());
        this.complaintReplyRepository.save((Object)entity);
        this.complaintRepository.updateComplaintStateById(complaintState, dto.getComplaintId());
        this.complaintReplyFileService.create(dto.getFileList(), entity.getId());
        return entity;
    }

    private void createValidation(ComplaintReplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getComplaintId(), (String)"\u7f3a\u5931\u6295\u8bc9id", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getReplierType(), (String)"\u7f3a\u5931\u56de\u590d\u4eba\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getReplyContent(), (String)"\u7f3a\u5931\u56de\u590d\u5185\u5bb9", (Object[])new Object[0]);
        List replierTypeList = Arrays.stream(ReplierType.values()).map(ReplierType::getCode).collect(Collectors.toList());
        Validate.isTrue((boolean)replierTypeList.contains(dto.getReplierType()), (String)"\u4e0d\u652f\u6301\u7684\u56de\u590d\u4eba\u7c7b\u578b!", (Object[])new Object[0]);
        Validate.isTrue((dto.getReplyContent().length() < 500 ? 1 : 0) != 0, (String)"\u56de\u590d\u5185\u5bb9\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(500)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

