/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintRepository;
import com.biz.crm.dms.business.interaction.local.service.base.AbstractRelationDataService;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintFileService;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintStateDto;
import com.biz.crm.dms.business.interaction.sdk.enums.ComplaintState;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="complaintService")
public class ComplaintServiceImpl
extends AbstractRelationDataService
implements ComplaintService {
    @Autowired(required=false)
    private ComplaintRepository complaintRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ComplaintFileService complaintFileService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public ComplaintEntity create(ComplaintDto dto) {
        if (dto == null || StringUtils.isBlank((CharSequence)dto.getCustomerCode()) || StringUtils.isBlank((CharSequence)dto.getCustomerName())) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u53c2\u6570\u4f20\u9012\uff0c\u8bf7\u6307\u5b9a\u5ba2\u6237\u4fe1\u606f");
        }
        String customerCode = dto.getCustomerCode();
        String customerName = dto.getCustomerName();
        dto.setCustomerCode(customerCode);
        dto.setCustomerName(customerName);
        this.createValidation(dto);
        dto.setComplaintCode((String)this.generateCodeService.generateCode("TSJY", 1).get(0));
        ComplaintEntity entity = (ComplaintEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ComplaintEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setComplaintState(ComplaintState.WAIT_FACTORY_DEAL.getCode());
        this.complaintRepository.save((Object)entity);
        this.complaintFileService.create(dto.getFileList(), entity.getId());
        return entity;
    }

    @Override
    @Transactional
    public void updateComplaintState(ComplaintStateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getComplaintId(), (String)"\u7f3a\u5931\u6295\u8bc9id", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getComplaintState(), (String)"\u7f3a\u5931\u6295\u8bc9\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((ComplaintState.RESOLVED.getCode().equals(dto.getComplaintState()) || ComplaintState.UNDONE.getCode().equals(dto.getComplaintState()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u53ea\u652f\u6301\u89e3\u51b3\u548c\u64a4\u9500\u64cd\u4f5c!", (Object[])new Object[0]);
        ComplaintEntity entity = (ComplaintEntity)((Object)this.complaintRepository.getById((Serializable)((Object)dto.getComplaintId())));
        Validate.notNull((Object)((Object)entity), (String)"\u6295\u8bc9\u5efa\u8bae\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((ComplaintState.WAIT_FACTORY_DEAL.getCode().equals(entity.getComplaintState()) || ComplaintState.WAIT_CUSTOMER_RETURN_VISIT.getCode().equals(entity.getComplaintState()) ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u6295\u8bc9\u5efa\u8bae\u72b6\u6001\u4e3a:%s,\u4e0d\u652f\u6301\u5f53\u524d\u64cd\u4f5c!", ComplaintState.getDesc((String)entity.getComplaintState())), (Object[])new Object[0]);
        this.complaintRepository.updateComplaintStateById(dto.getComplaintState(), dto.getComplaintId());
    }

    @Override
    public Page<ComplaintEntity> findByComplaintCustomerPageDto(Pageable pageable, ComplaintCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (ComplaintCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new ComplaintCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.buildCustomerPageDto((AbstractCustomerPageDto)dto);
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            return null;
        }
        return this.complaintRepository.findByComplaintCustomerPageDto(pageable, dto);
    }

    @Override
    public Page<ComplaintEntity> findByConditions(Pageable pageable, ComplaintPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (ComplaintPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new ComplaintPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.complaintRepository.findByConditions(pageable, dto);
    }

    private void createValidation(ComplaintDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getComplaintType(), (String)"\u7f3a\u5931\u6295\u8bc9\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getComplaintTitle(), (String)"\u7f3a\u5931\u6295\u8bc9\u6807\u9898", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getComplaintContent(), (String)"\u7f3a\u5931\u6295\u8bc9\u5185\u5bb9", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u7f3a\u5931\u5ba2\u6237\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((dto.getComplaintTitle().length() <= 128 ? 1 : 0) != 0, (String)"\u6295\u8bc9\u6807\u9898\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getComplaintContent().length() <= 500 ? 1 : 0) != 0, (String)"\u6295\u8bc9\u5185\u5bb9\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(500)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getComplainantContact()) || dto.getComplainantContact().length() < 30 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(30)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

