/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationFileEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationFileRepository;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationFileService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.InteractionFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="companyInformationFileService")
public class CompanyInformationFileServiceImpl
implements CompanyInformationFileService {
    private static final Logger log = LoggerFactory.getLogger(CompanyInformationFileServiceImpl.class);
    @Autowired(required=false)
    private CompanyInformationFileRepository companyInformationFileRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<InteractionFileDto> dtoList, String informationId) {
        Validate.notBlank((CharSequence)informationId, (String)"\u516c\u53f8\u8d44\u6599ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.companyInformationFileRepository.deleteByInformationId(informationId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(Objects::nonNull).map(dto -> {
            CompanyInformationFileEntity entity = (CompanyInformationFileEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CompanyInformationFileEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setInformationId(informationId);
            entity.setTenantCode(tenantCode);
            entity.setSortNum(dtoList.indexOf(dto));
            entity.setFileCode(dto.getFileCode());
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.companyInformationFileRepository.saveBatch(entities);
    }
}

