/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="companyInformationScopeService")
public class CompanyInformationScopeServiceImpl
implements CompanyInformationScopeService {
    private static final Logger log = LoggerFactory.getLogger(CompanyInformationScopeServiceImpl.class);
    @Autowired(required=false)
    private CompanyInformationScopeRepository companyInformationScopeRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<ScopeDto> dtoList, String informationId) {
        Validate.notBlank((CharSequence)informationId, (String)"\u516c\u53f8\u8d44\u6599ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.companyInformationScopeRepository.deleteByInformationId(informationId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getScopeCode()) && StringUtils.isNotEmpty((CharSequence)dto.getScopeType())).map(dto -> {
            CompanyInformationScopeEntity entity = (CompanyInformationScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CompanyInformationScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setInformationId(informationId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.companyInformationScopeRepository.saveBatch(entities);
    }
}

