/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationRepository;
import com.biz.crm.dms.business.interaction.local.service.base.AbstractRelationDataService;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationFileService;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationScopeService;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationPageDto;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.event.CompanyInformationEventListener;
import com.biz.crm.dms.business.interaction.sdk.vo.information.CompanyInformationEventVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="companyInformationService")
public class CompanyInformationServiceImpl
extends AbstractRelationDataService
implements CompanyInformationService {
    private static final Logger log = LoggerFactory.getLogger(CompanyInformationServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CompanyInformationRepository noticeRepository;
    @Autowired(required=false)
    private CompanyInformationFileService noticeFileService;
    @Autowired(required=false)
    private CompanyInformationScopeService noticeScopeService;
    @Autowired(required=false)
    private List<CompanyInformationEventListener> listeners;

    @Override
    @Transactional
    public CompanyInformationEntity create(CompanyInformationDto dto) {
        this.createValidation(dto);
        CompanyInformationEntity entity = (CompanyInformationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CompanyInformationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.noticeRepository.save((Object)entity);
        this.noticeFileService.update(dto.getFileList(), entity.getId());
        this.noticeScopeService.update(dto.getScopeList(), entity.getId());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            CompanyInformationEventVo vo = (CompanyInformationEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public CompanyInformationEntity update(CompanyInformationDto dto) {
        this.updateValidation(dto);
        CompanyInformationEntity entity = (CompanyInformationEntity)((Object)this.noticeRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u516c\u53f8\u8d44\u6599\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        CompanyInformationEntity updateEntity = (CompanyInformationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CompanyInformationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.noticeRepository.updateById((Object)updateEntity);
        this.noticeFileService.update(dto.getFileList(), entity.getId());
        this.noticeScopeService.update(dto.getScopeList(), entity.getId());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            CompanyInformationEventVo oldVo = (CompanyInformationEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            CompanyInformationEventVo newVo = (CompanyInformationEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.noticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.noticeRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CompanyInformationEntity.class, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.noticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.noticeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CompanyInformationEntity.class, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.noticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.noticeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CompanyInformationEntity.class, CompanyInformationEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    public Page<CompanyInformationEntity> findByConditions(Pageable pageable, CompanyInformationPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CompanyInformationPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CompanyInformationPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.noticeRepository.findByConditions(pageable, dto);
    }

    @Override
    public Page<CompanyInformationEntity> findByCompanyInformationCustomerPageDto(Pageable pageable, CompanyInformationCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CompanyInformationCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CompanyInformationCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.buildCustomerPageDto((AbstractCustomerPageDto)dto);
        return this.noticeRepository.findByCompanyInformationCustomerPageDto(pageable, dto);
    }

    private void createValidation(CompanyInformationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u7f3a\u5931\u8d44\u6599\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u8d44\u6599\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(noticeScopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
            });
        }
        Validate.isTrue((dto.getName().length() < 128 ? 1 : 0) != 0, (String)"\u8d44\u6599\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(CompanyInformationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u7f3a\u5931\u8d44\u6599\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u8d44\u6599\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(noticeScopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
            });
        }
        Validate.isTrue((dto.getName().length() < 128 ? 1 : 0) != 0, (String)"\u8d44\u6599\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

