/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.notice.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeReadRecordEntity;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeReadRecordRepository;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeReadRecordService;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeReadRecordDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="noticeReadRecordService")
public class NoticeReadRecordServiceImpl
implements NoticeReadRecordService {
    private static final Logger log = LoggerFactory.getLogger(NoticeReadRecordServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NoticeReadRecordRepository noticeReadRecordRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public NoticeReadRecordEntity create(NoticeReadRecordDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        String customerCode = dto.getCustomerCode();
        Validate.isTrue((!ObjectUtils.isEmpty((Object)loginUser) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        dto.setCustomerCode(customerCode);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getNoticeId(), (String)"\u7f3a\u5931\u516c\u544aID", (Object[])new Object[0]);
        NoticeReadRecordEntity recordEntity = this.noticeReadRecordRepository.findByNoticeIdAndCustomerCode(dto.getNoticeId(), dto.getCustomerCode());
        if (Objects.nonNull((Object)recordEntity)) {
            log.info("\u8be5\u5ba2\u6237\u5df2\u7ecf\u9605\u8bfb\u4e86\u6b64\u516c\u544a!");
            return recordEntity;
        }
        NoticeReadRecordEntity entity = (NoticeReadRecordEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, NoticeReadRecordEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.noticeReadRecordRepository.save((Object)entity);
        return entity;
    }
}

