/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.notice.internal;

import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeScopeService")
public class NoticeScopeServiceImpl
implements NoticeScopeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeScopeServiceImpl.class);
    @Autowired(required=false)
    private NoticeScopeRepository noticeScopeRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<ScopeDto> dtoList, String noticeId) {
        Validate.notBlank((CharSequence)noticeId, (String)"\u516c\u544aID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.noticeScopeRepository.deleteByNoticeId(noticeId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getScopeCode()) && StringUtils.isNotEmpty((CharSequence)dto.getScopeType())).map(dto -> {
            NoticeScopeEntity entity = (NoticeScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, NoticeScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setNoticeId(noticeId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.noticeScopeRepository.saveBatch(entities);
    }
}

