/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.notice.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeEntity;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeReadRecordEntity;
import com.biz.crm.dms.business.interaction.local.model.NoticeModelVo;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeFileRepository;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeModelRepository;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeReadRecordRepository;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeRepository;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.base.AbstractRelationDataService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticePageDto;
import com.biz.crm.dms.business.interaction.sdk.enums.NoticePopupType;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.service.notice.NoticeVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.notice.NoticeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class NoticeVoServiceImpl
extends AbstractRelationDataService
implements NoticeVoService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NoticeRepository noticeRepository;
    @Autowired(required=false)
    private NoticeModelRepository noticeModelRepository;
    @Autowired(required=false)
    private NoticeReadRecordRepository noticeReadRecordRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NoticeFileRepository noticeFileRepository;
    @Autowired(required=false)
    private NoticeScopeRepository noticeScopeRepository;

    public Page<NoticeVo> findByConditions(Pageable pageable, NoticePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (NoticePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new NoticePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<NoticeModelVo> modelPage = this.noticeModelRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(modelPage.getCurrent(), modelPage.getSize(), modelPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)modelPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)modelPage.getRecords(), NoticeModelVo.class, NoticeVo.class, HashSet.class, ArrayList.class, new String[0]);
        Date now = new Date();
        list.forEach(e -> {
            if (e.getStartTime().after(now)) {
                e.setNoticeState("0");
            }
            if (!e.getStartTime().after(now) && !e.getEndTime().before(now)) {
                e.setNoticeState("1");
            }
            if (e.getEndTime().before(now)) {
                e.setNoticeState("2");
            }
        });
        pageResult.setRecords(list);
        return pageResult;
    }

    public Page<NoticeVo> findByNoticeCustomerPageDto(Pageable pageable, NoticeCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (NoticeCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new NoticeCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.buildCustomerPageDto((AbstractCustomerPageDto)dto);
        Page<NoticeEntity> entityPage = this.noticeRepository.findByNoticeCustomerPageDto(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), NoticeEntity.class, NoticeVo.class, HashSet.class, ArrayList.class, new String[0]));
        List<String> noticeIds = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        List<NoticeReadRecordEntity> recordEntities = this.noticeReadRecordRepository.findByNoticeIdsAndCustomerCode(noticeIds, dto.getCustomerCode());
        Map<Object, Object> recordEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(recordEntities)) {
            recordEntityMap = recordEntities.stream().collect(Collectors.toMap(NoticeReadRecordEntity::getNoticeId, t -> t, (key1, key2) -> key2));
        }
        for (NoticeVo noticeVo : list) {
            noticeVo.setHaveRead(Boolean.valueOf(Objects.nonNull(recordEntityMap.get(noticeVo.getId()))));
        }
        Date now = new Date();
        list.forEach(e -> {
            if (e.getStartTime().after(now)) {
                e.setNoticeState("0");
            }
            if (!e.getStartTime().after(now) && !e.getEndTime().before(now)) {
                e.setNoticeState("1");
            }
            if (e.getEndTime().before(now)) {
                e.setNoticeState("2");
            }
        });
        pageResult.setRecords((List)list);
        if (ObjectUtils.isNotEmpty((Object)dto.getHaveRead())) {
            List lists = dto.getHaveRead() != false ? list.stream().filter(NoticeVo::getHaveRead).collect(Collectors.toList()) : list.stream().filter(e -> e.getHaveRead() == false).collect(Collectors.toList());
            pageResult.setRecords(lists);
        }
        return pageResult;
    }

    public NoticeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        NoticeEntity entity = this.noticeRepository.findById(id);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        NoticeVo noticeVo = (NoticeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, NoticeVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectScopeInfo(noticeVo.getScopeList());
        return noticeVo;
    }

    @Transactional
    public void create(List<NoticeDto> dtoList) {
        this.createValidation(dtoList);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        String orgCode = (String)loginUser.invokeFieldValue("orgCode");
        String orgName = (String)loginUser.invokeFieldValue("orgName");
        List<NoticeEntity> noticeEntities = dtoList.stream().map(dto -> {
            NoticeEntity entity = (NoticeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList(dto, NoticeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setPublishOrgCode(orgCode);
            entity.setPublishOrgName(orgName);
            return entity;
        }).collect(Collectors.toList());
        this.noticeRepository.saveBatch(noticeEntities);
        this.saveExtInfo(noticeEntities);
    }

    private void saveExtInfo(List<NoticeEntity> noticeEntities) {
        ArrayList noticeScopeEntities = Lists.newArrayList();
        ArrayList noticeFileEntities = Lists.newArrayList();
        noticeEntities.forEach(noticeEntity -> {
            if (!CollectionUtils.isEmpty(noticeEntity.getScopeList())) {
                noticeEntity.getScopeList().forEach(noticeScopeEntity -> {
                    noticeScopeEntity.setTenantCode(noticeEntity.getTenantCode());
                    noticeScopeEntity.setNoticeId(noticeEntity.getId());
                });
                noticeScopeEntities.addAll(noticeEntity.getScopeList());
            }
            if (!CollectionUtils.isEmpty(noticeEntity.getFileList())) {
                noticeEntity.getFileList().forEach(noticeFileEntity -> {
                    noticeFileEntity.setTenantCode(noticeEntity.getTenantCode());
                    noticeFileEntity.setNoticeId(noticeEntity.getId());
                });
                noticeFileEntities.addAll(noticeEntity.getFileList());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)noticeScopeEntities)) {
            this.noticeScopeRepository.saveBatch(noticeScopeEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)noticeFileEntities)) {
            this.noticeFileRepository.saveBatch(noticeFileEntities);
        }
    }

    private void createValidation(List<NoticeDto> dtoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtoList) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dtoList.forEach(dto -> {
            dto.setId(null);
            dto.setTenantCode(TenantUtils.getTenantCode());
            Validate.notBlank((CharSequence)dto.getTitle(), (String)"\u7f3a\u5931\u6807\u9898", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u7c7b\u578b", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getIndexPopup(), (String)"\u7f3a\u5931\u9996\u9875\u662f\u5426\u5f39\u51fa", (Object[])new Object[0]);
            if (Boolean.TRUE.equals(dto.getIndexPopup())) {
                Validate.notBlank((CharSequence)dto.getPopupType(), (String)"\u7f3a\u5931\u5f39\u51fa\u7c7b\u578b", (Object[])new Object[0]);
                List popupTypeList = Arrays.stream(NoticePopupType.values()).map(NoticePopupType::getDictCode).collect(Collectors.toList());
                Validate.isTrue((boolean)popupTypeList.contains(dto.getPopupType()), (String)"\u4e0d\u652f\u6301\u7684\u5f39\u51fa\u7c7b\u578b!", (Object[])new Object[0]);
            }
            Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
                dto.getScopeList().forEach(noticeScopeDto -> {
                    List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                    Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
                });
            }
            Validate.isTrue((dto.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u6807\u9898\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        });
    }
}

