/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.itextpdf.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.itextpdf.local.service.ITextPdfVoService;
import com.biz.crm.dms.business.itextpdf.sdk.vo.dto.ITextPdfDto;
import com.biz.crm.vo.UploadVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/itextpdf/iTextPdf"})
@Api(tags={"itextpdf\u76f8\u5173\u7684http"})
public class ITextPdfVoController {
    private static final Logger log = LoggerFactory.getLogger(ITextPdfVoController.class);
    @Autowired(required=false)
    private ITextPdfVoService iTextPdfVoService;

    @ApiOperation(value="\u901a\u8fc7file\u6587\u4ef6\u83b7\u53d6pdf")
    @PostMapping(value={"/createPdfByFile"})
    public Result<UploadVo> createPdfByFile(@RequestBody ITextPdfDto iTextPdfDto) {
        try {
            MultipartFile file = iTextPdfDto.getFile();
            return Result.ok((Object)this.iTextPdfVoService.createPdfByFile(file));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7html\u83b7\u53d6pdf")
    @PostMapping(value={"/createPdfByHtml"})
    public Result<UploadVo> createPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto) {
        try {
            String html = iTextPdfDto.getHtmlStr();
            return Result.ok((Object)this.iTextPdfVoService.createPdfByHtml(html));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

