/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.itextpdf.local.service.internal;

import com.biz.crm.dms.business.itextpdf.local.service.FileUploadVoService;
import com.biz.crm.dms.business.itextpdf.local.service.ITextPdfVoService;
import com.biz.crm.dms.business.itextpdf.local.utils.MultipartFileUtils;
import com.biz.crm.vo.UploadVo;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ITextPdfVoServiceImpl
implements ITextPdfVoService {
    private static final Logger log = LoggerFactory.getLogger(ITextPdfVoServiceImpl.class);
    @Autowired(required=false)
    private FileUploadVoService fileUploadVoService;

    @Override
    public UploadVo createPdfByFile(MultipartFile html) {
        Validate.notNull((Object)html, (String)"\u8bf7\u9009\u62e9\u6587\u4ef6\uff01", (Object[])new Object[0]);
        return this.fileUploadVoService.upload(html);
    }

    @Override
    public UploadVo createPdfByHtml(String html) {
        Validate.notNull((Object)html, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            ByteArrayOutputStream stream = this.html2Pdf(html);
            MultipartFile multipartFile = MultipartFileUtils.getMultipartFile(new ByteArrayInputStream(stream.toByteArray()), System.currentTimeMillis() + ".pdf");
            UploadVo uploadVo = this.fileUploadVoService.upload(multipartFile);
            return uploadVo;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ByteArrayOutputStream html2Pdf(String html) throws IOException {
        ConverterProperties props = new ConverterProperties();
        this.setFont(props);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PdfWriter writer = new PdfWriter((OutputStream)bao);
        PdfDocument pdf = new PdfDocument(writer);
        pdf.setDefaultPageSize(PageSize.A4);
        Document document = HtmlConverter.convertToDocument((String)html, (PdfDocument)pdf, (ConverterProperties)props);
        document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
        document.getRenderer().close();
        document.close();
        return bao;
    }

    private void setFont(ConverterProperties props) throws IOException {
        DefaultFontProvider defaultFontProvider = new DefaultFontProvider(false, false, false);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("font/SourceHanSansCN-Regular.ttf");
        byte[] bytes = MultipartFileUtils.toByteArray(inputStream);
        PdfFont regularFont = PdfFontFactory.createFont((byte[])bytes, (String)"Identity-H", (boolean)false);
        defaultFontProvider.addFont(regularFont.getFontProgram());
        InputStream boldInputStream = this.getClass().getClassLoader().getResourceAsStream("font/SourceHanSansCN-Bold.ttf");
        byte[] boldBytes = MultipartFileUtils.toByteArray(boldInputStream);
        PdfFont boldFont = PdfFontFactory.createFont((byte[])boldBytes, (String)"Identity-H", (boolean)false);
        defaultFontProvider.addFont(boldFont.getFontProgram());
        props.setFontProvider((FontProvider)defaultFontProvider);
    }
}

