/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.itextpdf.local.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class MultipartFileUtils {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File multipartFileToFile(MultipartFile file) {
        if (Objects.isNull(file)) {
            return null;
        }
        try (InputStream ins = file.getInputStream();){
            File File2 = new File(file.getOriginalFilename());
            MultipartFileUtils.inputStreamToFile(ins, File2);
            File file2 = File2;
            return file2;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inputStreamToFile(InputStream ins, File file) {
        try (FileOutputStream os = new FileOutputStream(file);){
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteTempFile(File file) {
        File del;
        if (file != null && !(del = new File(file.toURI())).delete()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    public static MultipartFile getMultipartFile(InputStream inputStream, String fileName) {
        FileItem fileItem = MultipartFileUtils.createFileItem(inputStream, fileName);
        return new CommonsMultipartFile(fileItem);
    }

    public static FileItem createFileItem(InputStream inputStream, String fileName) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "file";
        FileItem item = factory.createItem(textFieldName, "multipart/form-data", true, fileName);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try (OutputStream os = item.getOutputStream();){
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            log.error("Stream copy exception", (Throwable)e);
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] toByteArray(InputStream input) {
        try {
            byte[] byArray;
            Throwable throwable;
            ByteArrayOutputStream output;
            block24: {
                block25: {
                    output = new ByteArrayOutputStream();
                    throwable = null;
                    byte[] buffer = new byte[4096];
                    int n = 0;
                    while (-1 != (n = input.read(buffer))) {
                        output.write(buffer, 0, n);
                    }
                    byArray = output.toByteArray();
                    if (output == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        output.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                output.close();
            }
            return byArray;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (output != null) {
                            if (throwable != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                output.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

