package com.biz.crm.dms.business.message.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.message.local.notifier.DemoListenerImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统消息demo: demo: 系统消息demo
 *
 * @author sunx
 * @date 2022/7/5
 */
@Slf4j
@Api(tags = "系统消息demo: demo: 系统消息demo")
@RestController
@RequestMapping(value = {"/v1/systemMessage/demo"})
public class DemoController {

  @Autowired(required = false)
  private DemoListenerImpl demoListener;

  /**
   * demo测试
   *
   * @param orderCode
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "demo测试")
  @GetMapping("/send")
  public Result<?> send(
      @RequestParam("orderCode") String orderCode,
      @RequestParam("businessCode") String businessCode) {
    try {
      this.demoListener.closeOrder(orderCode, businessCode);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * demo发货延迟测试
   *
   * @param orderCode
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "demo发货延迟测试")
  @GetMapping("/sendDelivery")
  public Result<?> sendDelivery(
      @RequestParam("orderCode") String orderCode,
      @RequestParam("businessCode") String businessCode) {
    try {
      this.demoListener.deliveryDelay(orderCode, businessCode);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
