/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.cart.local.helper.OrderCartHelper;
import com.biz.crm.dms.business.order.cart.sdk.constant.OrderCartConstant;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartCustomerDto;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartUpdateDto;
import com.biz.crm.dms.business.order.cart.sdk.service.OrderCartVoService;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/orderCart"})
@Api(tags={"\u5546\u57ce\u8ba2\u5355: OrderCartVo: \u8d2d\u7269\u8f66"})
public class OrderCartVoController {
    private static final Logger log = LoggerFactory.getLogger(OrderCartVoController.class);
    @Autowired(required=false)
    private OrderCartVoService orderCartVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private OrderCartHelper orderCartHelper;

    @ApiOperation(value="\u5546\u57ce\u8d2d\u7269\u8f66\u5217\u8868")
    @GetMapping(value={"/findByOrderCartCustomerDto"})
    public Result<List<OrderCartVo>> findByOrderCartCustomerDto(@ApiParam(name="OrderCartCustomerDto", value="\u53c2\u6570Dto") OrderCartCustomerDto dto) {
        try {
            return Result.ok((Object)this.orderCartVoService.findByOrderCartCustomerDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fee\u6539\u8d2d\u7269\u8f66\u4e2d\u7684\u5546\u54c1\u6570\u91cf")
    @PatchMapping(value={"/updateQuantity"})
    public Result<OrderCartVo> updateQuantity(@RequestBody OrderCartUpdateDto dto) {
        String lockKey = this.orderCartHelper.buildCashLockKeyByCustomerCode();
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, OrderCartConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u5176\u4ed6\u767b\u5f55\u8d26\u53f7\u64cd\u4f5c\u8d2d\u7269\u8f66,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (Object[])new Object[0]);
        try {
            OrderCartVo orderCartVo = this.orderCartVoService.updateQuantity(dto);
            Result result = Result.ok((Object)orderCartVo);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fee\u6539\u8d2d\u7269\u8f66\u4e2d\u7684\u5546\u54c1\u6570\u91cf")
    @PostMapping(value={"/updateQuantityTurnPatch"})
    public Result<OrderCartVo> updateQuantityTurnPatch(@RequestBody OrderCartUpdateDto dto) {
        String lockKey = this.orderCartHelper.buildCashLockKeyByCustomerCode();
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, OrderCartConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u5176\u4ed6\u767b\u5f55\u8d26\u53f7\u64cd\u4f5c\u8d2d\u7269\u8f66,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (Object[])new Object[0]);
        try {
            OrderCartVo orderCartVo = this.orderCartVoService.updateQuantity(dto);
            Result result = Result.ok((Object)orderCartVo);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }
}

