/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartDto;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartProductDto;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.sdk.dto.OrderDetailPreviewDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.service.OrderPreviewService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPreviewVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class OrderCartHelper {
    private static final Logger log = LoggerFactory.getLogger(OrderCartHelper.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private OrderPreviewService orderPreviewService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private AllowSaleListVoService allowSaleListVoService;

    public String buildCashLockKeyByCustomerCode() {
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)loginDetails) ? 1 : 0) != 0, (String)"\u767b\u5f55\u4fe1\u606f\u9519\u8bef", (Object[])new Object[0]);
        String customerCode = loginDetails.getCustomerCode();
        String tenantCode = loginDetails.getTenantCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return String.format("OrderCartLock_%s_%s", customerCode, tenantCode);
    }

    public void createValidation(OrderCartDto dto) {
        Validate.isTrue((!ObjectUtils.isEmpty((Object)dto) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getOrderCartProductDtoList()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u96c6\u5408\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)loginDetails) ? 1 : 0) != 0, (String)"\u767b\u5f55\u4fe1\u606f\u9519\u8bef", (Object[])new Object[0]);
        String customerCode = loginDetails.getCustomerCode();
        dto.setCustomerCode(customerCode);
        String account = loginDetails.getAccount();
        dto.setAccount(account);
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.getOrderCartProductDtoList().forEach(o -> {
            Validate.notBlank((CharSequence)o.getSpuCode(), (String)"SPU\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductCode(), (String)"SKU\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!ObjectUtils.isEmpty((Object)o.getQuantity()) ? 1 : 0) != 0, (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((o.getQuantity().compareTo(0) > 0 ? 1 : 0) != 0, (String)"\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6", (Object[])new Object[0]);
        });
    }

    public void buildAddEntity(Map<String, OrderCartEntity> addMap, OrderCartDto dto, OrderCartProductDto cartProductDto) {
        OrderCartEntity entity = new OrderCartEntity();
        entity.setCustomerCode(dto.getCustomerCode());
        entity.setAccount(dto.getAccount());
        entity.setSpuCode(cartProductDto.getSpuCode());
        entity.setTenantCode(dto.getTenantCode());
        entity.setProductCode(cartProductDto.getProductCode());
        entity.setQuantity(cartProductDto.getQuantity());
        addMap.put(cartProductDto.getProductCode(), entity);
    }

    public void buildUpdateQuantity(Map<String, OrderCartEntity> updateMap, OrderCartEntity existEntity, OrderCartProductDto cartProductDto) {
        Integer quantity = existEntity.getQuantity();
        Integer addQuantity = cartProductDto.getQuantity();
        existEntity.setQuantity(quantity + addQuantity);
        updateMap.put(cartProductDto.getProductCode(), existEntity);
    }

    private Set<String> findAllowSaleProductCodes(String customerCode, List<String> productCodes) {
        ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
        dto.setBusinessCode(customerCode);
        dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
        dto.setProductCodeList(productCodes);
        List list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
        return Sets.newHashSet((Iterable)list);
    }

    public void buildProductInfo(List<OrderCartVo> cartVos) {
        if (CollectionUtils.isEmpty(cartVos)) {
            return;
        }
        JSONObject loginUserJson = this.loginUserService.getLoginUserJson();
        String customerCode = loginUserJson.getString("customerCode");
        List<String> productCodes = cartVos.stream().map(OrderCartVo::getProductCode).collect(Collectors.toList());
        List detailsByIdsOrProductCodes = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)detailsByIdsOrProductCodes) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5546\u54c1sku\u7684\u8be6\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        Map productVoMap = detailsByIdsOrProductCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        FindPriceDto findPriceDto = new FindPriceDto();
        findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
        findPriceDto.setUserCode(customerCode);
        findPriceDto.setProductCodeSet((Set)Sets.newHashSet(productCodes));
        Map price = this.priceModelVoService.findPrice(findPriceDto);
        Set<String> allowSaleProductCodes = this.findAllowSaleProductCodes(customerCode, productCodes);
        cartVos.forEach(item -> {
            ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
            item.setProductName(productVo.getProductName());
            item.setUnite(productVo.getSaleUnit());
            item.setSpec(productVo.getSpec());
            item.setPrimaryPictureUrl(productVo.getPrimaryPictureUrl());
            item.setPictureMediaList(productVo.getPictureMediaList());
            item.setVideoMediaList(productVo.getVideoMediaList());
            item.setIsShelf(productVo.getIsShelf());
            item.setIsAllowsale(Boolean.valueOf(allowSaleProductCodes.contains(item.getProductCode())));
            PriceModelVo priceModelVo = (PriceModelVo)price.get(item.getProductCode());
            item.setPresetUnitPrice(Optional.ofNullable(priceModelVo).orElse(new PriceModelVo()).getPrice());
        });
        HashMap<String, OrderCartVo> map = new HashMap<String, OrderCartVo>(cartVos.size());
        for (OrderCartVo cartVo : cartVos) {
            String productCode = cartVo.getProductCode();
            OrderCartVo orderCartVo = (OrderCartVo)map.get(productCode);
            if (ObjectUtils.isEmpty((Object)orderCartVo)) {
                map.put(productCode, cartVo);
                continue;
            }
            Integer quantity = orderCartVo.getQuantity();
            Integer quantity1 = cartVo.getQuantity();
            cartVo.setQuantity(Integer.valueOf(quantity + quantity1));
            map.put(productCode, cartVo);
        }
        cartVos = Lists.newArrayList(map.values());
    }

    public void buildPolicyInfo(List<OrderCartVo> cartVos) {
        if (CollectionUtils.isEmpty(cartVos)) {
            return;
        }
        OrderCartVo orderCartVo = cartVos.get(0);
        OrderPreviewDto orderPreviewDto = new OrderPreviewDto();
        orderPreviewDto.setRelateCode(orderCartVo.getCustomerCode());
        orderPreviewDto.setOrderCategory(OrderCategoryEnum.SALES_ORDER.getDictCode());
        orderPreviewDto.setOrderType(OrderTypeEnum.STANDARD.getDictCode());
        ArrayList orderDetails = Lists.newArrayList();
        cartVos.forEach(o -> {
            OrderDetailPreviewDto previewDto = new OrderDetailPreviewDto();
            previewDto.setGoodsCode(o.getProductCode());
            previewDto.setQuantity(new BigDecimal(o.getQuantity()));
            previewDto.setItemType(ItemTypeEnum.NORMAL_GOODS.getDictCode());
            previewDto.setIsAutoHit(Boolean.valueOf(true));
            previewDto.setSalesAmount(new BigDecimal(1200));
            orderDetails.add(previewDto);
        });
        orderPreviewDto.setOrderDetails((List)orderDetails);
        OrderPreviewVo orderPreviewVo = this.orderPreviewService.handlePreview(orderPreviewDto);
        String cityCode = orderPreviewVo.getCityCode();
        Map itemMap = orderPreviewVo.getOrderDetails().stream().collect(Collectors.toMap(OrderDetailPreviewVo::getGoodsCode, Function.identity()));
        cartVos.forEach(item -> {
            OrderDetailPreviewVo previewVo = (OrderDetailPreviewVo)itemMap.get(item.getProductCode());
            this.buildItem((OrderCartVo)item, previewVo);
        });
    }

    private void buildItem(OrderCartVo item, OrderDetailPreviewVo previewVo) {
        item.setOrderDetailPays(previewVo.getOrderDetailPays());
        item.setSalesAmount(previewVo.getSalesAmount());
        item.setShouldPaymentAmount(previewVo.getShouldPaymentAmount());
        item.setPresetUnitPrice(previewVo.getPresetUnitPrice());
        item.setActualUnitPrice(previewVo.getActualUnitPrice());
        item.setAverageUnitPrice(previewVo.getAverageUnitPrice());
    }
}

