/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.local.mapper.OrderCartMapper;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartCustomerDto;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderCartRepository
extends ServiceImpl<OrderCartMapper, OrderCartEntity> {
    @Autowired(required=false)
    private OrderCartMapper orderCartMapper;

    public void deleteBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).remove();
    }

    public List<OrderCartEntity> findByCustomerCodeAndSpuCodeAndProductCodes(String customerCode, List<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(OrderCartEntity::getProductCode, productCodes)).eq(OrderCartEntity::getCustomerCode, (Object)customerCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<OrderCartVo> findByOrderCartCustomerDto(OrderCartCustomerDto dto) {
        return this.orderCartMapper.findByOrderCartCustomerDto(dto);
    }

    public void deleteByProductCodeInAndCustomerCode(Collection<String> productCodes, String customerCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(OrderCartEntity::getProductCode, productCodes)).eq(OrderCartEntity::getCustomerCode, (Object)customerCode)).remove();
    }
}

