/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.local.helper.OrderCartHelper;
import com.biz.crm.dms.business.order.cart.local.repository.OrderCartRepository;
import com.biz.crm.dms.business.order.cart.local.service.OrderCartService;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartDto;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartProductDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="orderCartService")
public class OrderCartServiceImpl
implements OrderCartService {
    private static final Logger log = LoggerFactory.getLogger(OrderCartServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrderCartRepository orderCartRepository;
    @Autowired(required=false)
    private OrderCartHelper orderCartHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatch(OrderCartDto dto) {
        this.orderCartHelper.createValidation(dto);
        List<String> productCodes = dto.getOrderCartProductDtoList().stream().map(OrderCartProductDto::getProductCode).collect(Collectors.toList());
        List spuCodes = dto.getOrderCartProductDtoList().stream().map(OrderCartProductDto::getSpuCode).collect(Collectors.toList());
        List<OrderCartEntity> existEntities = this.orderCartRepository.findByCustomerCodeAndSpuCodeAndProductCodes(dto.getCustomerCode(), productCodes);
        Map existMap = existEntities.stream().collect(Collectors.toMap(OrderCartEntity::getProductCode, Function.identity()));
        HashMap addMap = Maps.newHashMap();
        HashMap updateMap = Maps.newHashMap();
        dto.getOrderCartProductDtoList().forEach(o -> {
            String key = o.getProductCode();
            OrderCartEntity existEntity = (OrderCartEntity)((Object)((Object)existMap.get(key)));
            if (ObjectUtils.isEmpty((Object)((Object)existEntity))) {
                this.orderCartHelper.buildAddEntity(addMap, dto, (OrderCartProductDto)o);
            } else {
                this.orderCartHelper.buildUpdateQuantity(updateMap, existEntity, (OrderCartProductDto)o);
            }
        });
        if (!addMap.isEmpty()) {
            this.orderCartRepository.saveBatch(addMap.values());
        }
        if (!updateMap.isEmpty()) {
            this.orderCartRepository.saveOrUpdateBatch(updateMap.values());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8d2d\u7269\u8f66ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.orderCartRepository.deleteBatch(ids);
    }
}

