/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.local.helper.OrderCartHelper;
import com.biz.crm.dms.business.order.cart.local.repository.OrderCartRepository;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartCustomerDto;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartUpdateDto;
import com.biz.crm.dms.business.order.cart.sdk.service.OrderCartVoService;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="orderCartVoService")
public class OrderCartVoServiceImpl
implements OrderCartVoService {
    private static final Logger log = LoggerFactory.getLogger(OrderCartVoServiceImpl.class);
    @Autowired(required=false)
    private OrderCartRepository orderCartRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private OrderCartHelper orderCartHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public OrderCartVo updateQuantity(OrderCartUpdateDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8d2d\u7269\u8f66\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)dto.getQuantity()) ? 1 : 0) != 0, (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderCartEntity cartEntity = (OrderCartEntity)((Object)this.orderCartRepository.getById((Serializable)((Object)dto.getId())));
        Validate.isTrue((!ObjectUtils.isEmpty((Object)((Object)cartEntity)) ? 1 : 0) != 0, (String)"\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u8be5\u5546\u54c1", (Object[])new Object[0]);
        cartEntity.setQuantity(dto.getQuantity());
        this.orderCartRepository.updateById((Object)cartEntity);
        OrderCartVo orderCartVo = (OrderCartVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cartEntity, OrderCartVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList orderCartVos = Lists.newArrayList();
        orderCartVos.add(orderCartVo);
        this.orderCartHelper.buildProductInfo(orderCartVos);
        return (OrderCartVo)orderCartVos.get(0);
    }

    public List<OrderCartVo> findByOrderCartCustomerDto(OrderCartCustomerDto dto) {
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (ObjectUtils.isEmpty((Object)loginDetails) || StringUtils.isEmpty((Object)loginDetails.getCustomerCode())) {
            return Lists.newArrayList();
        }
        dto.setCustomerCode(loginDetails.getCustomerCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<OrderCartVo> cartVos = this.orderCartRepository.findByOrderCartCustomerDto(dto);
        this.orderCartHelper.buildProductInfo(cartVos);
        return cartVos;
    }
}

