package com.biz.crm.dms.business.order.cart.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.local.entity
 * @ClassName OrderCartEntity
 * @Author YangWei
 * @Date 2022/4/1 下午3:16
 * @Description 订单购物车
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_cart")
@Table(name = "dms_order_cart")
@ApiModel(value = "OrderCartEntity", description = "订单购物车")
@org.hibernate.annotations.Table(appliesTo = "dms_order_cart", comment = "订单购物车")
public class OrderCartEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 5235876781799535823L;

  /**
   * 登录账号
   */
  @ApiModelProperty(name = "account", value = "登录账号")
  @Column(name = "account", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '登录账号'")
  private String account;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "customerCode", value = "客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '客户编码'")
  private String customerCode;

  /**
   * SPU商品编码
   */
  @ApiModelProperty("SPU商品编码")
  @TableField(value = "spu_code")
  @Column(name = "spu_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' SPU商品编码 '")
  private String spuCode;

  /**
   * SKU商品编码
   */
  @ApiModelProperty("SKU商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' SKU商品编码 '")
  private String productCode;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  @TableField(value = "quantity")
  @Column(name = "quantity", length = 11, columnDefinition = "INT(11) COMMENT '数量'")
  private Integer quantity;
}