package com.biz.crm.dms.business.order.cart.local.notifer;

import com.biz.crm.dms.business.order.cart.local.repository.OrderCartRepository;
import com.biz.crm.dms.business.order.sdk.dto.OrderEventDto;
import com.biz.crm.dms.business.order.sdk.event.OrderLogEventListener;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 订单事件监听器impl
 *
 * @author hefan
 * @date 2022/07/07
 */
@Service
public class OrderLogEventListenerOfCart implements OrderLogEventListener {

  @Autowired(required = false)
  private OrderCartRepository orderCartRepository;

  @Override
  public void onCreate(OrderEventDto eventDto) {
    //
    OrderVo newest = eventDto.getNewest();
    if (ObjectUtils.isEmpty(newest)) {
      return;
    }
    List<OrderDetailVo> orderDetails = newest.getOrderDetails();
    if (CollectionUtils.isEmpty(orderDetails)) {
      return;
    }
    Set<String> set = new HashSet(orderDetails.size());
    for (OrderDetailVo orderDetail : orderDetails) {
      String goodsCode = orderDetail.getGoodsCode();
      set.add(goodsCode);
    }
    String relateCode = newest.getRelateCode();
    orderCartRepository.deleteByProductCodeInAndCustomerCode(set, relateCode);

  }

  @Override
  public void onClose(OrderEventDto orderEventDto) {
    // 不需要实现
  }
}
