package com.biz.crm.dms.business.order.cart.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.local.mapper.OrderCartMapper;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartCustomerDto;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.local.repository
 * @ClassName OrderCartRepository
 * @Author YangWei
 * @Date 2022/4/1 下午4:33
 * @Description 购物车
 */
@Component
public class OrderCartRepository extends ServiceImpl<OrderCartMapper, OrderCartEntity> {

  @Autowired(required = false)
  private OrderCartMapper orderCartMapper;

  /**
   * 删除购物车中的商品
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate().in(OrderCartEntity::getId,ids).remove();
  }

  /**
   * 根据客户以及商品编码查询是否存在
   * @param customerCode
   * @param productCodes
   * @return
   */
  public List<OrderCartEntity> findByCustomerCodeAndSpuCodeAndProductCodes(String customerCode, List<String> productCodes) {
    return this.lambdaQuery()
        .in(OrderCartEntity::getProductCode,productCodes)
        .eq(OrderCartEntity::getCustomerCode,customerCode)
        .eq(OrderCartEntity::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 商城购物车列表
   * @param dto
   * @return
   */
  public List<OrderCartVo> findByOrderCartCustomerDto(OrderCartCustomerDto dto) {
    return this.orderCartMapper.findByOrderCartCustomerDto(dto);
  }

  /**
   * 删除-根据商品编码集合和客户编码
   *
   * @param productCodes 商品编码集合
   * @param customerCode 客户编码
   */
  public void deleteByProductCodeInAndCustomerCode(Collection<String> productCodes, String customerCode) {
    this.lambdaUpdate()
        .in(OrderCartEntity::getProductCode, productCodes)
        .eq(OrderCartEntity::getCustomerCode, customerCode)
        .remove();
  }
}