package com.biz.crm.dms.business.order.cart.local.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.cart.local.entity.OrderCartEntity;
import com.biz.crm.dms.business.order.cart.local.helper.OrderCartHelper;
import com.biz.crm.dms.business.order.cart.local.repository.OrderCartRepository;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartCustomerDto;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartUpdateDto;
import com.biz.crm.dms.business.order.cart.sdk.service.OrderCartVoService;
import com.biz.crm.dms.business.order.cart.sdk.vo.OrderCartVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.local.service.internal
 * @ClassName OrderCartVoServiceImpl
 * @Author YangWei
 * @Date 2022/4/2 上午11:10
 * @Description 购物车Vo实现
 */
@Slf4j
@Service("orderCartVoService")
public class OrderCartVoServiceImpl implements OrderCartVoService {

  @Autowired(required = false)
  private OrderCartRepository orderCartRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private OrderCartHelper orderCartHelper;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 修改购物车中的商品数量
   * @param dto
   * @return {@link OrderCartVo}
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public OrderCartVo updateQuantity(OrderCartUpdateDto dto) {
    Validate.notBlank(dto.getId(),"购物车主键ID不能为空");
    Validate.isTrue(!ObjectUtils.isEmpty(dto.getQuantity()),"数量不能为空");
    OrderCartEntity cartEntity = this.orderCartRepository.getById(dto.getId());
    Validate.isTrue(!ObjectUtils.isEmpty(cartEntity),"购物车中不存在该商品");
    cartEntity.setQuantity(dto.getQuantity());
    this.orderCartRepository.updateById(cartEntity);
    OrderCartVo orderCartVo = this.nebulaToolkitService.copyObjectByWhiteList(cartEntity, OrderCartVo.class, HashSet.class, ArrayList.class);
    List<OrderCartVo> orderCartVos = Lists.newArrayList();
    orderCartVos.add(orderCartVo);
    //构建商品信息
    this.orderCartHelper.buildProductInfo(orderCartVos, dto.getCustomerCode());
    //构建政策信息
    //this.orderCartHelper.buildPolicyInfo(orderCartVos);
    return orderCartVos.get(0);
  }

  /**
   * 商城购物车列表
   * @param dto
   * @return
   */
  @Override
  public List<OrderCartVo> findByOrderCartCustomerDto(OrderCartCustomerDto dto) {
    String customerCode = dto.getCustomerCode();
    AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
    if(ObjectUtils.isEmpty(loginUser)){
      return Lists.newArrayList();
    }
    if(StringUtils.isBlank(customerCode)){
      return Lists.newArrayList();
    }
    dto.setCustomerCode(customerCode);
    dto.setTenantCode(TenantUtils.getTenantCode());
    List<OrderCartVo> cartVos = this.orderCartRepository.findByOrderCartCustomerDto(dto);
    //构建商品信息
    this.orderCartHelper.buildProductInfo(cartVos, dto.getCustomerCode());
    //构建政策信息
    //this.orderCartHelper.buildPolicyInfo(cartVos);
    return cartVos;
  }
}