/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.cart.local.helper.OrderCartHelper;
import com.biz.crm.dms.business.order.cart.local.service.OrderCartService;
import com.biz.crm.dms.business.order.cart.sdk.constant.OrderCartConstant;
import com.biz.crm.dms.business.order.cart.sdk.dto.OrderCartDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/orderCart"})
@Api(tags={"\u5546\u57ce\u8ba2\u5355: OrderCart: \u8d2d\u7269\u8f66"})
public class OrderCartController {
    private static final Logger log = LoggerFactory.getLogger(OrderCartController.class);
    @Autowired(required=false)
    private OrderCartService orderCartService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private OrderCartHelper orderCartHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66")
    @PostMapping(value={"/addBatch"})
    public Result addBatch(@RequestBody OrderCartDto dto) {
        String customerCode = dto.getCustomerCode();
        String lockKey = this.orderCartHelper.buildCashLockKeyByCustomerCode(customerCode);
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, OrderCartConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u5176\u4ed6\u767b\u5f55\u8d26\u53f7\u64cd\u4f5c\u8d2d\u7269\u8f66,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (Object[])new Object[0]);
        try {
            this.orderCartService.addBatch(dto);
            Result result = Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5220\u9664\u8d2d\u7269\u8f66\u4e2d\u7684\u5546\u54c1")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids, @RequestParam(value="customerCode") String customerCode) {
        String lockKey = this.orderCartHelper.buildCashLockKeyByCustomerCode(customerCode);
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, OrderCartConstant.TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u5176\u4ed6\u767b\u5f55\u8d26\u53f7\u64cd\u4f5c\u8d2d\u7269\u8f66,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (Object[])new Object[0]);
        try {
            this.orderCartService.deleteBatch(ids);
            Result result = Result.ok((String)"\u5220\u9664\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }
}

