/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.cart.local.notifer;

import com.biz.crm.dms.business.order.cart.local.repository.OrderCartRepository;
import com.biz.crm.dms.business.order.sdk.dto.OrderEventDto;
import com.biz.crm.dms.business.order.sdk.event.OrderLogEventListener;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderLogEventListenerOfCart
implements OrderLogEventListener {
    @Autowired(required=false)
    private OrderCartRepository orderCartRepository;

    public void onCreate(OrderEventDto eventDto) {
        OrderVo newest = eventDto.getNewest();
        if (ObjectUtils.isEmpty((Object)newest)) {
            return;
        }
        List orderDetails = newest.getOrderDetails();
        if (CollectionUtils.isEmpty((Collection)orderDetails)) {
            return;
        }
        HashSet<String> set = new HashSet<String>(orderDetails.size());
        for (OrderDetailVo orderDetail : orderDetails) {
            String goodsCode = orderDetail.getGoodsCode();
            set.add(goodsCode);
        }
        String relateCode = newest.getRelateCode();
        this.orderCartRepository.deleteByProductCodeInAndCustomerCode(set, relateCode);
    }

    public void onClose(OrderEventDto orderEventDto) {
    }
}

