package com.biz.crm.dms.business.order.cart.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.sdk.dto
 * @ClassName OrderCartDto
 * @Author YangWei
 * @Date 2022/4/1 下午3:54
 * @Description 购物车Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderCartDto", description = "购物车Dto")
public class OrderCartDto extends TenantDto {

  /**
   * 登录账号
   */
  @ApiModelProperty(name = "account", value = "登录账号")
  private String account;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "customerCode", value = "客户编码")
  private String customerCode;

  /**
   * SKU商品编码集合
   */
  @ApiModelProperty("SKU商品编码集合")
  private List<OrderCartProductDto> orderCartProductDtoList;
}