package com.biz.crm.dms.business.order.cart.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.sdk.dto
 * @ClassName OrderCartProductDto
 * @Author YangWei
 * @Date 2022/4/2 上午9:46
 * @Description 购物车商品Dto
 */
@Data
@ApiModel(value = "OrderCartProductDto", description = "购物车商品Dto")
public class OrderCartProductDto implements Serializable {
  private static final long serialVersionUID = 549195569283131387L;

  /**
   * SPU商品编码
   */
  @ApiModelProperty("SPU商品编码")
  private String spuCode;

  /**
   * SKU商品编码
   */
  @ApiModelProperty("SKU商品编码")
  private String productCode;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private Integer quantity;
}