package com.biz.crm.dms.business.order.cart.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPayPreviewVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.sdk.vo
 * @ClassName OrderCartVo
 * @Author YangWei
 * @Date 2022/4/2 上午11:04
 * @Description 购物车Vo
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderCartVo", description = "公告信息Vo")
public class OrderCartVo extends TenantVo {
  private static final long serialVersionUID = -6257562631967450099L;

  /**
   * 登录账号
   */
  @ApiModelProperty(name = "account", value = "登录账号")
  private String account;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "customerCode", value = "客户编码")
  private String customerCode;

  /**
   * SPU商品编码
   */
  @ApiModelProperty("SPU商品编码")
  private String spuCode;

  /**
   * SKU商品编码
   */
  @ApiModelProperty("SKU商品编码")
  private String productCode;

  /**
   * SKU商品名称
   */
  @ApiModelProperty("SKU商品名称")
  private String productName;

  /** 主图片url */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private Integer quantity;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  private BigDecimal presetUnitPrice;

  /**
   * 实际单价 = 组内分摊后的单价（正向）
   */
  @ApiModelProperty("实际单价 = 组内分摊后的单价（正向）")
  private BigDecimal actualUnitPrice;

  /**
   * 全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）
   */
  @ApiModelProperty("全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）")
  private BigDecimal averageUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  private BigDecimal salesAmount;

  /**
   * 实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）
   */
  @ApiModelProperty("实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）")
  private BigDecimal shouldPaymentAmount;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 是否允销 */
  @ApiModelProperty("是否允销")
  private Boolean isAllowsale;

  /**
   * 政策信息
   */
  @ApiModelProperty("政策信息")
  private List<OrderDetailPayPreviewVo> orderDetailPays;

  /** 图片信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;

  /** 视频信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaVo> videoMediaList;
}