package com.biz.crm.dms.business.order.cart.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.order.cart.sdk.dto
 * @ClassName OrderCartCustomerDto
 * @Author YangWei
 * @Date 2022/4/2 上午11:30
 * @Description 商城购物车查询Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderCartCustomerDto", description = "购物车Dto")
public class OrderCartCustomerDto extends TenantDto {

  /**
   * 登录账号
   */
  @ApiModelProperty(name = "account", value = "登录账号")
  private String account;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "customerCode", value = "客户编码")
  private String customerCode;
}