package com.biz.crm.dms.business.order.common.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderSourceEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.PickUpWayEnum;
import com.biz.crm.dms.business.order.common.sdk.service.EnumVoService;
import com.biz.crm.dms.business.order.common.sdk.vo.EnumVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统内订单枚举信息
 * @author he fan
 */
@RestController
@RequestMapping("/v1/orderCommon/enum")
@Slf4j
@Api(tags = "订单模块-通用：EnumVo：系统内订单枚举信息")
public class EnumVoController {

  @Autowired(required = false)
  EnumVoService enumVoService;

  /**
   * 根据 OrderTypeEnum 枚举查询
   *
   * @return
   */
  @ApiOperation(value = "根据 OrderTypeEnum 枚举查询")
  @GetMapping("/findByOrderTypeEnum")
  public Result<List<EnumVo>> findByOrderTypeEnum() {
    try {
      List<EnumVo> all = this.enumVoService.findByEnumClass(OrderTypeEnum.class);
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 OrderSourceEnum 枚举查询
   *
   * @return
   */
  @ApiOperation(value = "根据 OrderSourceEnum 枚举查询")
  @GetMapping("/findByOrderSourceEnum")
  public Result<List<EnumVo>> findByOrderSourceEnum() {
    try {
      List<EnumVo> all = this.enumVoService.findByEnumClass(OrderSourceEnum.class);
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 OrderStatusEnum 枚举查询
   *
   * @return
   */
  @ApiOperation(value = "根据 OrderStatusEnum 枚举查询")
  @GetMapping("/findByOrderStatusEnum")
  public Result<List<EnumVo>> findByOrderStatusEnum() {
    try {
      List<EnumVo> all = this.enumVoService.findByEnumClass(OrderStatusEnum.class);
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 PickUpWayEnum 枚举查询
   *
   * @return
   */
  @ApiOperation(value = "根据 PickUpWayEnum 枚举查询")
  @GetMapping("/findByPickUpWayEnum")
  public Result<List<EnumVo>> findByPickUpWayEnum() {
    try {
      List<EnumVo> all = this.enumVoService.findByEnumClass(PickUpWayEnum.class);
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 PickUpWayEnum 枚举查询
   *
   * @return
   */
  @ApiOperation(value = "根据 ItemTypeEnum 枚举查询")
  @GetMapping("/findByItemTypeEnum")
  public Result<List<EnumVo>> findByItemTypeEnum() {
    try {
      List<EnumVo> all = this.enumVoService.findByEnumClass(ItemTypeEnum.class);
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
