package com.biz.crm.dms.business.order.common.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.service.TallyItemRegisterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统内记账项目
 * @author he fan
 */
@RestController
@RequestMapping("/v1/orderCommon/tallyItem")
@Slf4j
@Api(tags = "订单模块-通用：TallyItemRegister：系统内记账项目")
public class TallyItemRegisterModelController {

  @Autowired(required = false)
  TallyItemRegisterService tallyItemRegisterService;

  /**
   * 查询系统内的记账项目
   *
   * @return
   */
  @ApiOperation(value = "查询系统内的记账项目")
  @GetMapping("/findAll")
  public Result<List<TallyItemRegisterModel>> findAll() {
    try {
      List<TallyItemRegisterModel> all = this.tallyItemRegisterService.findAll();
      return Result.ok(all);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



}
