package com.biz.crm.dms.business.order.common.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.service.EnumVoService;
import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import com.biz.crm.dms.business.order.common.sdk.vo.EnumVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author he fan
 */
@Service
public class EnumVoServiceImpl implements EnumVoService {

  @Override
  public List<EnumVo> findByEnumArray(VisibleEnum[] values) {
    if (ArrayUtils.isEmpty(values)) {
      return null;
    }
    List<EnumVo> enumVos = Lists.newLinkedList();
    for (int i = 0; i < values.length; i++) {
      VisibleEnum visibleEnum = values[i];
      EnumVo vo = new EnumVo();
      vo.setKey(visibleEnum.getKey());
      vo.setDictCode(visibleEnum.getDictCode());
      vo.setOrder(visibleEnum.getOrder());
      vo.setValue(visibleEnum.getValue());
      enumVos.add(vo);
    }
    return enumVos;
  }

  @Override
  public List<EnumVo> findByEnumClass(Class<? extends VisibleEnum> visibleEnumClass) {
    if (!visibleEnumClass.isEnum()) {
      return null;
    }
    if (visibleEnumClass.isAssignableFrom(VisibleEnum.class)) {
      return null;
    }
    return this.findByEnumArray(visibleEnumClass.getEnumConstants());
  }
}
