package com.biz.crm.dms.business.order.common.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.common.sdk.service.TallyItemRegisterService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author he fan
 */
@Service("TallyItemRegisterServiceImpl")
public class TallyItemRegisterServiceImpl implements TallyItemRegisterService {

  @Autowired(required = false)
  private List<TallyItemRegister> tallyItemRegisters;

  @Override
  public List<TallyItemRegisterModel> findByItemGroupKey(String itemGroupKey) {
    List<TallyItemRegisterModel> models = Lists.newLinkedList();
    if (StringUtils.isBlank(itemGroupKey)) {
      return models;
    }
    if (CollectionUtils.isEmpty(tallyItemRegisters)) {
      return models;
    }
    for (TallyItemRegister tallyItemRegister : tallyItemRegisters) {
      TallyItemRegisterModel tallyItemRegisterModel = tallyItemRegister.findTallyItemRegisterModel();
      if (itemGroupKey.equals(tallyItemRegisterModel.getItemGroupKey())) {
        models.add(tallyItemRegisterModel);
      }
    }
    return models;
  }

  @Override
  public TallyItemRegisterModel findByItemKey(String itemKey) {
    if (StringUtils.isBlank(itemKey)) {
      return null;
    }
    if (CollectionUtils.isEmpty(tallyItemRegisters)) {
      return null;
    }
    for (TallyItemRegister tallyItemRegister : tallyItemRegisters) {
      TallyItemRegisterModel tallyItemRegisterModel = tallyItemRegister.findTallyItemRegisterModel();
      if (itemKey.equals(tallyItemRegisterModel.getItemKey())) {
        return tallyItemRegisterModel;
      }
    }
    return null;
  }

  @Override
  public List<TallyItemRegisterModel> findAll() {
    List<TallyItemRegisterModel> models = Lists.newLinkedList();
    if (CollectionUtils.isEmpty(tallyItemRegisters)) {
      return models;
    }
    for (TallyItemRegister tallyItemRegister : tallyItemRegisters) {
      models.add(tallyItemRegister.findTallyItemRegisterModel());
    }
    return models;
  }

  @Override
  public TallyItemRegisterModel findByItemGroupKeyAndItemKey(String itemGroupKey, String itemKey) {
    TallyItemRegisterModel model = this.findByItemKey(itemKey);
    if (itemGroupKey.equals(model.getItemGroupKey())) {
      return model;
    }
    return null;
  }
}
