/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.common.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.common.sdk.service.TallyItemRegisterService;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TallyItemRegisterServiceImpl")
public class TallyItemRegisterServiceImpl
implements TallyItemRegisterService {
    @Autowired(required=false)
    private List<TallyItemRegister> tallyItemRegisters;

    public List<TallyItemRegisterModel> findByItemGroupKey(String itemGroupKey) {
        LinkedList models = Lists.newLinkedList();
        if (StringUtils.isBlank((CharSequence)itemGroupKey)) {
            return models;
        }
        if (CollectionUtils.isEmpty(this.tallyItemRegisters)) {
            return models;
        }
        for (TallyItemRegister tallyItemRegister : this.tallyItemRegisters) {
            TallyItemRegisterModel tallyItemRegisterModel = tallyItemRegister.findTallyItemRegisterModel();
            if (!itemGroupKey.equals(tallyItemRegisterModel.getItemGroupKey())) continue;
            models.add(tallyItemRegisterModel);
        }
        return models;
    }

    public TallyItemRegisterModel findByItemKey(String itemKey) {
        if (StringUtils.isBlank((CharSequence)itemKey)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.tallyItemRegisters)) {
            return null;
        }
        for (TallyItemRegister tallyItemRegister : this.tallyItemRegisters) {
            TallyItemRegisterModel tallyItemRegisterModel = tallyItemRegister.findTallyItemRegisterModel();
            if (!itemKey.equals(tallyItemRegisterModel.getItemKey())) continue;
            return tallyItemRegisterModel;
        }
        return null;
    }

    public List<TallyItemRegisterModel> findAll() {
        LinkedList models = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(this.tallyItemRegisters)) {
            return models;
        }
        for (TallyItemRegister tallyItemRegister : this.tallyItemRegisters) {
            models.add(tallyItemRegister.findTallyItemRegisterModel());
        }
        return models;
    }

    public TallyItemRegisterModel findByItemGroupKeyAndItemKey(String itemGroupKey, String itemKey) {
        TallyItemRegisterModel model = this.findByItemKey(itemKey);
        if (itemGroupKey.equals(model.getItemGroupKey())) {
            return model;
        }
        return null;
    }
}

