package com.biz.crm.dms.business.order.common.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单明细行上该扣金额的项目
 * @author hefan
 */
@Data
@ApiModel(value = "OrderDetailPayTabulateDto", description = "订单明细行上该扣金额的项目")
public class OrderDetailPayTabulateDto {

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  private String itemName;

  /**
   * 该扣项目金额数据的由来的别名
   * 比如：【政策优惠】选择了的促销政策的名称
   */
  @ApiModelProperty("该扣项目金额数据的由来的别名")
  private String originDataAlias;

  /**
   * 项目可用
   */
  @ApiModelProperty("项目可用")
  private Boolean available;

  /**
   * 不可用原因
   */
  @ApiModelProperty("不可用原因")
  private String reason;

}
