package com.biz.crm.dms.business.order.common.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 *订单的总的记账项目Dto（该扣项目、支付项目）
 * @author he fan
 */
@Data
@ApiModel(value = "OrderPayDto", description = "订单的总的记账项目Dto（该扣项目、支付项目）")
public class OrderPayDto {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 项目组类型：【0该扣项目、1支付项目】
   */
  @ApiModelProperty("项目组类型：【0该扣项目、1支付项目】")
  private Boolean itemGroupType;

  /**
   * 项目组的key
   */
  @ApiModelProperty("项目组的key")
  private String itemGroupKey;

  /**
   * 项目key
   */
  @ApiModelProperty("项目key")
  private String itemKey;

  /**
   * 项目名称
   */
  @ApiModelProperty("项目名称")
  private String itemName;

  /**
   * 项目金额
   */
  @ApiModelProperty("项目金额")
  private BigDecimal itemAmount;

}
