package com.biz.crm.dms.business.order.common.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 订单汇总
 *
 * @author he fan
 */
@Data
@ApiModel(value = "OrderTabulateDto", description = "订单汇总")
public class OrderTabulateDto {

  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  private BigDecimal totalOrderAmount;

  /**
   * 本单实际支付 == 实际支付金额
   */
  @ApiModelProperty("本单实际支付 == 实际支付金额")
  private BigDecimal actualAmountPaid;

  /**
   * 政策优惠金额
   */
  @ApiModelProperty("政策优惠金额 = 本单所有优惠金额汇总，商品优惠政策和整单优惠政策都包含")
  private BigDecimal policyDiscountAmount;

  /**
   * 货补扣减金额
   */
  @ApiModelProperty("货补扣减金额")
  private BigDecimal totalCompensatedAmount;

  /**
   * 存放订单里的货物
   */
  @ApiModelProperty("订单明细 == 存放订单里的货物")
  private List<OrderDetailTabulateDto> orderDetails;
}
