package com.biz.crm.dms.business.order.common.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 订单类型
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@AllArgsConstructor
public enum MaterielOrderTypeEnum implements VisibleEnum {
  /**
   * 客户订单
   */
  CUSTOMER_ORDER("CUSTOMER_ORDER", "customerOrder", "客户订单", "1"),
  /**
   * 组织订单
   */
  ORGANIZATION("ORGANIZATION", "organization", "组织订单", "2"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static MaterielOrderTypeEnum findByCode(String code) {
    Optional<MaterielOrderTypeEnum> first = Stream.of(MaterielOrderTypeEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
