package com.biz.crm.dms.business.order.common.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 订单校验流程节点
 *
 * @author pengxi
 * @date 2022/03/02
 */
@Getter
@AllArgsConstructor
public enum OrderValidationProcessNodeEnum implements VisibleEnum {
  /**
   * 订单校验流程节点
   */
  /**
   * 校验商品关系
   */
  ONE("1", "one", "描述订单所处流程节点", "1"),
  /**
   * 起订量
   */
  TWO("2", "two", "描述订单所处流程节点", "2"),
  /**
   * 余额校验、库存
   */
  THREE("3", "three", "描述订单所处流程节点", "3"),
  /**
   * 费比
   */
  FOUR("4", "four", "描述订单所处流程节点", "4"),
  /**
   * 最终校验
   */
  TEN("10", "ten", "描述订单所处流程节点", "10");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static OrderValidationProcessNodeEnum findByCode(String code) {
    Optional<OrderValidationProcessNodeEnum> first = Stream.of(OrderValidationProcessNodeEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
