package com.biz.crm.dms.business.order.common.sdk.service;

import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;

import java.util.List;

/**
 * @author he fan
 */
public interface TallyItemRegisterService {

  /**
   * 根据itemGroupKey查询
   * --可用作校验记账项目组在系统中是否存在
   *
   * @param itemGroupKey
   * @return
   */
  List<TallyItemRegisterModel> findByItemGroupKey(String itemGroupKey);

  /**
   * 根据itemKey查询
   * --可用作校验记账项目在系统中是否存在
   * @param itemKey
   * @return
   */
  TallyItemRegisterModel findByItemKey(String itemKey);

  /**
   * 查询现在系统中已经存在的记账项目
   *
   * @return
   */
  List<TallyItemRegisterModel> findAll();

  /**
   * 根据itemKey、itemGroupKey查询
   * --可用作校验记账项目与记账项目组在系统中是否匹配关系
   * @param itemGroupKey
   * @param itemKey
   * @return
   */
  TallyItemRegisterModel findByItemGroupKeyAndItemKey(String itemGroupKey, String itemKey);
}
