package com.biz.crm.dms.business.order.common.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

/**
 * 订单配置生效维度VO
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigDimensionVo", description = "订单配置生效维度VO")
public class OrderConfigDimensionVo extends TenantVo {
  private static final long serialVersionUID = 2789128537560081051L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * （客户或组织）编码
   */
  @ApiModelProperty("（客户或组织）编码")
  private String code;

  /**
   * （客户或组织）名称
   */
  @ApiModelProperty("（客户或组织）名称")
  private String name;

}
