package com.biz.crm.dms.business.order.common.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 订单配置VO
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigVo", description = "订单配置VO")
public class OrderConfigVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 6035197024676626091L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 是否默认设定
   *  1.1默认设定：订单类型作为唯一校验，订单类型选择重复了则不允许提交
   *  1.2非默认设定：订单类型+配置生效的客户编码/组织编码作为唯一校验，不能重复
   */
  @ApiModelProperty("是否默认设定")
  private Boolean isDefault;

  /**
   * 生效类型：客户 customer；组织 org
   */
  @ApiModelProperty("生效类型：客户 customer；组织 org")
  private String effectiveType;

  /**
   * 是否揉价
   */
  @ApiModelProperty("是否揉价")
  private Boolean isKneadingPrice = false;

  /**
   * 揉价策略实现类名称
   */
  @ApiModelProperty("揉价策略实现类名称")
  private String kneadingPriceName;

  /**
   * 是否拆单
   */
  @ApiModelProperty("是否拆单")
  private Boolean isSplitOrder;

  /**
   * 拆单策略实现类名称
   */
  @ApiModelProperty("拆单策略实现类名称")
  private String splitOrderName;

  /**
   * 订单配置校验
   */
  private List<OrderConfigVerificationVo> verificationVoList;

  /**
   * 生效维度
   */
  private List<OrderConfigDimensionVo> dimensionVoList;
}
