package com.biz.crm.dms.business.order.common.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailPayDto", description = "订单行内数据由来--比如，本品选择的优惠政策")
public class OrderDetailPayDto {

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策CODE
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  private String originData;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  private String originDataType;
}
