package com.biz.crm.dms.business.order.common.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Transient;
import java.util.List;

/**
 * 包含订单最基本信息的dto
 * -- 不含收货地址信息
 *
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDto", description = "包含订单最基本信息的dto")
public class OrderDto {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 原始订单编码
   */
  @ApiModelProperty("原始订单编码")
  private String originalOrderCode;

  /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  private String orderSource;

  /**
   * 订单类别：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  private String orderStatus;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * TODO： 会上确认，组织编码是不是需要
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 存放订单里的货物
   */
  @ApiModelProperty("订单明细 == 存放订单里的货物")
  private List<OrderDetailDto> orderDetails;

  /**
   * 订单的总的记账项目
   */
  @ApiModelProperty("订单的总的记账项目")
  @TableField(exist = false)
  @Transient
  private List<OrderPayDto> orderPays;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 仓库编码 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;
}
