package com.biz.crm.dms.business.order.common.sdk.enums;


import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 行项目类型
 * •服务的属性：com.biz.crm.dms.business.order.local.entity.OrderDetail#itemType
 * •这是给订单明细——商品的属性itemType定义的枚举
 *
 * @author he fan
 */
@Getter
@AllArgsConstructor
public enum ItemTypeEnum implements VisibleEnum {

  /**
   * 本品
   */
  NORMAL_GOODS("NORMAL_GOODS", "normalGoods", "本品", ""),

  /**
   * 赠品
   */
  COMPLIMENTARY_GOODS("COMPLIMENTARY_GOODS", "complimentaryGoods", "赠品", ""),
  /**
   * 货补
   */
  COMPENSATED_GOODS("COMPENSATED_GOODS", "compensatedGoods", "货补", ""),
  /**
   * 免费
   */
  FREE_GOODS("FREE_GOODS", "freeGoods", "免费", ""),
  /**
   * 折扣
   */
  DISCOUNT_GOODS("DISCOUNT_GOODS", "discountGoods", "折扣", ""),
  /**
   * 物料
   */
  MATERIAL_GOODS("MATERIAL_GOODS", "materialGoods", "物料", "");

  /**
   * 思考？
   * 如果不用字典，由接口将这个枚举内的信息暴露给前端？
   */

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
