package com.biz.crm.dms.business.order.common.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 订单提交阶段枚举
 *
 * @author he fan
 */
@Getter
@AllArgsConstructor
public enum OrderCommitPhaseEnum {

  /**
   * 订单预览
   */
  PREVIEW("PREVIEW","preview","订单预览","1"),
  /**
   * 订单提交
   */
  SUBMIT("SUBMIT","submit","订单提交","2"),
  /**
   * 订单确认
   */
  CONFIRM("CONFIRM","confirm","订单确认","3");
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

}
