package com.biz.crm.dms.business.order.common.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 订单状态-枚举
 *
 * @author he fan
 */
@Getter
@AllArgsConstructor
public enum OrderStatusEnum implements VisibleEnum {

  /**
   * 暂存
   */
  STAGING("STAGING", "staging", "暂存", "1"),
  /**
   * 审批中、待审批
   */
  AWAIT_APPROVE("AWAIT_APPROVE", "awaitApprove", "审批中", "2"),
  /**
   * 驳回
   */
  REJECTED("REJECTED", "rejected", "驳回", "3"),
  /**
   * 已取消、流程撤回
   */
  CANCELED("CANCELED", "canceled", "流程撤回", "4"),
  /**
   * 待发货
   */
  WAIT_SHIPPED("WAIT_SHIPPED", "waitShipped", "待发货", "5"),
  /**
   * 部分发货
   */
  PART_SHIPPED("PART_SHIPPED", "partShipped", "部分发货", "6"),
  /**
   * 已完成
   */
  COMPLETED("COMPLETED", "completed", "已完成", "7"),
  /**
   * 关闭
   */
  CLOSE("CLOSE", "CLOSE", "关闭", "8"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static OrderStatusEnum findByCode(String code) {
    Optional<OrderStatusEnum> first = Stream.of(OrderStatusEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
