package com.biz.crm.dms.business.order.common.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 订单类型
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@AllArgsConstructor
public enum OrderTypeEnum implements VisibleEnum {
  /**
   * 标准订单
   */
  STANDARD("STANDARD", "standard", "标准订单", "1"),
  /**
   * 货补订单
   */
  REPLENISHMENT("REPLENISHMENT", "replenishment", "货补订单", "2"),
  /**
   * 折扣订单
   */
  DISCOUNT("DISCOUNT", "discount", "折扣订单", "3"),
  /**
   * 免费订单
   */
  FREE("FREE", "free", "免费订单", "4");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static OrderTypeEnum findByCode(String code) {
    Optional<OrderTypeEnum> first = Stream.of(OrderTypeEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
