package com.biz.crm.dms.business.order.common.sdk.model;

import com.biz.crm.dms.business.order.common.sdk.enums.TallyItemGroupTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 描述系统内的记账项目的信息
 *
 * @author he fan
 */
@Data
@ApiModel(value = "TallyItemRegisterModel", description = "描述系统内的记账项目的信息")
public class TallyItemRegisterModel {

  /**
   * 项目组类型
   */
  @ApiModelProperty("项目组类型")
  private TallyItemGroupTypeEnum tallyItemGroupType;

  /**
   * 项目组的key
   */
  @ApiModelProperty("项目组的key")
  private String itemGroupKey;

  /**
   * 项目组的名称
   */
  @ApiModelProperty("项目组的名称")
  private String itemGroupName;

  /**
   * 项目key
   */
  @ApiModelProperty("项目key")
  private String itemKey;

  /**
   * 项目名称
   */
  @ApiModelProperty("项目名称")
  private String itemName;


}
