package com.biz.crm.dms.business.order.common.sdk.register.internal;

import com.biz.crm.dms.business.order.common.sdk.enums.TallyItemGroupTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import org.springframework.stereotype.Service;

/**
 *
 * @author he fan
 */
@Service("CapitalTallyItemRegister")
public class CapitalTallyItemRegister implements TallyItemRegister {

  private static TallyItemRegisterModel tallyItemRegisterModel;

  static {
    tallyItemRegisterModel = new TallyItemRegisterModel();
    tallyItemRegisterModel.setItemKey("capital");
    tallyItemRegisterModel.setItemName("资金支付");
    tallyItemRegisterModel.setTallyItemGroupType(TallyItemGroupTypeEnum.PAYMENT);
    tallyItemRegisterModel.setItemGroupKey("paymentItemsStoredInTheSystem");
    tallyItemRegisterModel.setItemGroupName("系统内预存性质支付项目");
  }

  @Override
  public TallyItemRegisterModel findTallyItemRegisterModel() {
    return tallyItemRegisterModel;
  }

}
