package com.biz.crm.dms.business.order.common.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

/**
 * 订单配置校验VO
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigVerificationVo", description = "订单配置校验VO")
public class OrderConfigVerificationVo extends TenantVo {
  private static final long serialVersionUID = -8107092540423250415L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 策略实现名称
   */
  @ApiModelProperty("策略实现名称")
  private String name;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  private String title;

  /**
   * 是否开启
   */
  @ApiModelProperty("是否开启")
  private Boolean isOpen;
}
