/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.common.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import java.util.Optional;
import java.util.stream.Stream;

public enum OrderTypeEnum implements VisibleEnum
{
    STANDARD("STANDARD", "standard", "\u6807\u51c6\u8ba2\u5355", "1"),
    REPLENISHMENT("REPLENISHMENT", "replenishment", "\u8d27\u8865\u8ba2\u5355", "2"),
    DISCOUNT("DISCOUNT", "discount", "\u6298\u6263\u8ba2\u5355", "3"),
    FREE("FREE", "free", "\u514d\u8d39\u8ba2\u5355", "4");

    private String key;
    private String dictCode;
    private String value;
    private String order;

    public static OrderTypeEnum findByCode(String code) {
        Optional<OrderTypeEnum> first = Stream.of(OrderTypeEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
        return first.orElse(null);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDictCode() {
        return this.dictCode;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    private OrderTypeEnum(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.value = value;
        this.order = order;
    }
}

